% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_data.R
\name{county_aggregates}
\alias{county_aggregates}
\title{Get county level output}
\usage{
county_aggregates(flood_stats, county_cd)
}
\arguments{
\item{flood_stats}{Data frame of gage-level output from \code{flood_analysis}
function.}

\item{county_cd}{Character vector with the county FIPS code(s)}
}
\value{
A data frame with the following columns:
\tabular{lll}{
Name \tab Type \tab Description\cr
county \tab character \tab County name\cr
state \tab character \tab State name\cr
num_gage \tab numeric \tab Number of analyzed gages in county\cr
avg_peak \tab numeric \tab Average flood ratio among county gages\cr
max_peak \tab numeric \tab Maximum observed flood ratio\cr
minor \tab numeric \tab Percentage of gages at or above "minor" flood class (flood ratio > 1)\cr
moderate \tab numeric \tab Percentage of gages at or above "moderate" flood class (flood ratio > 1.5)\cr
major \tab numeric \tab Percentage of gages at or above "major" flood class (flood ratio > 2)\cr
extreme \tab numeric \tab Percentage of gages at or above "extreme" flood class (flood ratio > 5)\cr
max_dur \tab numeric \tab Maximum flood duration in county\cr
avg_dur \tab numeric \tab Average flood duration in county
}

If threshold = "NWS", the columns "minor", "moderate", "major", and "extreme"
are replaced with two columns: "no_flood" and "yes_flood" which show the
percentage of gages in the county with or without flooding.
}
\description{
Function aggregates gage-level output into county-level output
}
\examples{
\dontrun{
va_counties <- get_county_cd("Virginia")
va_gages <- get_gages(va_counties, start_date = "2015-01-01",
                      end_date = "2015-12-31")
va_flow_data <- get_flow_data(va_gages, start_date = "2015-01-01",
                      end_date = "2015-12-31")
va_peaks <- find_q2(va_gages$site_no)
va_stats <- flood_analysis(flow_data = va_flow_data, peaks = va_peaks,
                       gages = va_gages, county_cd = va_counties, threshold = "Q2")
va_county_stats <- county_aggregates(flood_stats = va_stats)
}
}
