% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_color_ranges.R
\name{rectangularRange}
\alias{rectangularRange}
\title{Find pixels within a target color range defined by boundaries in each channel}
\usage{
rectangularRange(pixel.array, upper, lower, target.color = "green",
  main = "", color.pixels = TRUE, plotting = TRUE)
}
\arguments{
\item{pixel.array}{An image represented as a 3D array (as read in by
\code{\link[jpeg]{readJPEG}}, \code{\link[png]{readPNG}}, or
\code{\link[colordistance]{loadImage}}) in which to change pixel colors.}

\item{upper, lower}{RGB triplet specifying the bounds of color space search.
See details.}

\item{target.color}{Color with which to replace specified pixels. Can be
either an RGB triplet or one of the colors listed by
\code{\link[grDevices]{colors}}.}

\item{main}{Optional title to display for image.}

\item{color.pixels}{Logical. Should a diagnostic image with pixels changed to
\code{target.color} be returned?}

\item{plotting}{Logical. Should output be plotted in the plot window?}
}
\value{
A list with the following elements:
\itemize{
  \item \code{pixel.idx}: Coordinates of pixels within color range.
  \item \code{img.fraction}: Proportion of the image within color range.
  \item \code{original.img}: The original RGB array.
  \item \code{indicator.img}: If \code{color.pixels = TRUE}, RGB array with
  color-swapped pixels.
}
}
\description{
Searches for pixels within a set of upper and lower limits for each color
channel. Essentially draws a 'box' around a region of color space in which to
search for pixels.
}
\details{
\code{lower} and \code{upper} should be vectors of length 3 in a 0-1 range,
in the order R-G-B. For example, the upper bounds for white would be c(1, 1,
1), and the lower bounds might be c(0.8, 0.8, 0.8). This would search for all
pixels where the red value, blue value, AND green value are all between 0.8
and 1.
}
\examples{
flowers <- jpeg::readJPEG(system.file("extdata", "flowers.jpg", package =
"countcolors"))

# Define upper and lower bounds for white
lower <- rep(0.8, 3)
upper <- rep(1, 3)

white.flowers <- countcolors::rectangularRange(flowers, rep(1, 3), rep(0.85,
3), target.color = "turquoise")

}
