% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first.R
\name{addConstraint}
\alias{addConstraint}
\title{Add constraints to optimization problem}
\usage{
addConstraint(p, ...)
}
\arguments{
\item{p}{optimization problem to add constraints.}

\item{...}{additional constraints.}
}
\value{
the optimization problem with the additional constraints.
}
\description{
\code{addConstraint} add additional constraints to optimization problem.
}
\examples{
if (setup()) {
    x <- Variable(4)
    b <- J(c(1:4))
    p <- minimize(sum((x - b) ^ 2))
    p <- addConstraint(p, x >= 0, x <= 3)
}
}
