% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_measures_of_location.R
\name{ci_quantile}
\alias{ci_quantile}
\title{CI for a Population Quantile}
\usage{
ci_quantile(
  x,
  q = 0.5,
  probs = c(0.025, 0.975),
  type = c("binomial", "bootstrap"),
  boot_type = c("bca", "perc", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{q}{A single probability value determining the quantile (0.5 for median).}

\item{probs}{Lower and upper probabilities, by default \code{c(0.025, 0.975)}.}

\item{type}{Type of CI. One of "binomial" (default), or "bootstrap".}

\item{boot_type}{Type of bootstrap CI. Only used for \code{type = "bootstrap"}.}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{\link[boot:boot]{boot::boot()}}.}
}
\value{
An object of class "cint", see \code{\link[=ci_mean]{ci_mean()}} for details.
}
\description{
This function calculates CIs for a population quantile. By default, distribution-free
CIs based on the binomial distribution are calculated, see Hahn and Meeker.
Alternatively, bootstrap CIs are available (default "bca").
}
\examples{
x <- 1:100
ci_quantile(x, q = 0.25)
}
\references{
Hahn, G. and Meeker, W. (1991). Statistical Intervals. Wiley 1991.
}
\seealso{
\code{\link[=ci_median]{ci_median()}}
}
