% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOutput.R
\name{getOutput}
\alias{getOutput}
\alias{plot.ConcreteOut}
\title{getOutput}
\usage{
getOutput(
  ConcreteEst,
  Estimand = c("Risk"),
  Intervention = seq_along(ConcreteEst),
  GComp = NULL,
  Simultaneous = TRUE,
  Signif = 0.05
)

\method{plot}{ConcreteOut}(x, NullLine = TRUE, ask = TRUE, ...)
}
\arguments{
\item{ConcreteEst}{"ConcreteEst" object}

\item{Estimand}{character: "RR" for Relative Risks, "RD" for Risk Differences, and "Risk" for absolute risks}

\item{Intervention}{numeric (default = seq_along(ConcreteEst)): the ConcreteEst list element
corresponding to the target intervention. For comparison estimands such as RD and RR,
Intervention should be a numeric vector with length 2, the first term designating
"treatment" ConcreteEst list element and the second designating the "control".}

\item{GComp}{logical: return g-formula point estimates based on initial nuisance parameter estimation}

\item{Simultaneous}{logical: return simultaneous confidence intervals}

\item{Signif}{numeric (default = 0.05): alpha for 2-tailed hypothesis testing}

\item{x}{a ConcreteOut object}

\item{NullLine}{logical: to plot a red line at y=1 for RR plots and at y=0 for RD plots}

\item{ask}{logical: to prompt for user input before each plot}

\item{...}{additional arguments to be passed into plot methods}
}
\value{
data.table of point estimates and standard deviations
}
\description{
getOutput
}
\section{Functions}{
\itemize{
\item \code{plot(ConcreteOut)}: plot.ConcreteOut plot method for "ConcreteOut" class

}}
\examples{
library(data.table)
library(concrete)

data <- as.data.table(survival::pbc)
data <- data[1:200, .SD, .SDcols = c("id", "time", "status", "trt", "age", "sex")]
data[, trt := sample(0:1, nrow(data), TRUE)]

# formatArguments() returns correctly formatted arguments for doConcrete()
concrete.args <- formatArguments(DataTable = data,
                                 EventTime = "time",
                                 EventType = "status",
                                 Treatment = "trt",
                                 ID = "id",
                                 TargetTime = 2500,
                                 TargetEvent = c(1, 2),
                                 Intervention = makeITT(),
                                 CVArg = list(V = 2))
                                 
# doConcrete() returns tmle (and g-formula plug-in) estimates of targeted risks
\donttest{
concrete.est <- doConcrete(concrete.args)

# getOutput returns risk difference, relative risk, and treatment-specific risks
#  GComp=TRUE returns g-formula plug-in estimates
#  Simultaneous=TRUE computes simultaneous CI for all output TMLE estimates 
concrete.out <- getOutput(concrete.est, Estimand = c("RR", "RD", "Risk"),
                          GComp = TRUE, Simultaneous = TRUE)
print(concrete.out)
plot(concrete.out, ask = FALSE)
}
}
