% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cor2cov}
\alias{cor2cov}
\title{Convert from Correlation Matrix to Covariance Matrix}
\usage{
cor2cov(sigma, corrMatrix)
}
\arguments{
\item{sigma}{A vector of standard deviations for the variables you're describing. Length must be the same as the number of rows/columns of CorrMatrix.}

\item{corrMatrix}{A valid correlation matrix.}
}
\value{
A covariance matrix with the same dimensions as corrMatrix.
}
\description{
Convert a correlation matrix to a covariance matrix.
}
\examples{
corr <- matrix(c(1, 0.53, 0.73, 0.53, 1, 0.44, 0.73, 0.44, 1), nrow = 3)
sigmas <- c(2, 0.3, 1.2)
covar <- cor2cov(sigmas, corr)
cov2cor(covar)
}
