% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{colored_multi_rnorm}
\alias{colored_multi_rnorm}
\title{Generate Multiple Cross-Correlated & Autocorrelated Variables}
\usage{
colored_multi_rnorm(timesteps, mean, sd, phi, covMatrix)
}
\arguments{
\item{timesteps}{The number of temporally autocorrelated random numbers (one
per timestep) you want.}

\item{mean}{A vector giving the mean of each variable.}

\item{sd}{A vector giving the standard deviation of each variable.}

\item{phi}{A vector giving the temporal autocorrelation of each variable.}

\item{covMatrix}{A valid covariance matrix. The number of rows/columns must match the length of the mu, sigma, and phi vectors.}
}
\value{
A matrix with as many rows as timesteps and as many columns as mu/sigma/phi values.
}
\description{
Generates random variables that are correlated to each other and temporally autocorrelated.
}
\examples{
cov <- matrix(c(0.037, 0.044, -0.048, 0.044, 0.247, -0.008, -0.047, -0.008, 0.074), nrow = 3)
test <- colored_multi_rnorm(100, c(0, 3, 5), c(1, 0.5, 1), c(0.5, -0.3, 0), cov)
var(test)
library(dplyr)
test \%>\% as.data.frame() \%>\% summarize_all(.funs = c("mean", "sd", "autocorrelation"))
}
