% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustMD_UtilityFunctions.R
\name{dtmvnom}
\alias{dtmvnom}
\title{Return the mean and covariance matrix of a truncated multivariate normal
distribution}
\usage{
dtmvnom(a, b, mu, S)
}
\arguments{
\item{a}{a vector of lower thresholds.}

\item{b}{a vector of upper thresholds.}

\item{mu}{the mean of the untruncated distribution.}

\item{S}{the covariance matrix of the untruncated distribution.}
}
\value{
Returns a list of two elements. The first element, \code{tmean}, is
    the mean of the truncated multivariate normal distribution. The second 
    element, \code{tvar}, is the covariance matrix of the truncated 
    distribution.
}
\description{
This function returns the mean and covariance matrix of a truncated 
multivariate normal distribution. It takes as inputs a vector of lower 
thresholds and another of upper thresholds along with the mean and 
covariance matrix of the untruncated distribution. This function follows
the method proposed by Kan \& Robotti (2016).
}
\references{
Kan, R., & Robotti, C. (2016). On Moments of Folded and 
    Truncated Multivariate  Normal Distributions. Available at SSRN.
}
\keyword{distribution}
\keyword{internal}
