% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/year_chart.R
\name{year_chart}
\alias{year_chart}
\title{Plot Values on Each Month of a Year}
\usage{
year_chart(mvalue, lgnm = "Value", width = 0.9, high = "yellow", low = "green")
}
\arguments{
\item{mvalue}{A numeric vector having values in each month of the year (starts
from January, obviously). If you have it in a data frame, you need to
extract it (one way is this: \code{data$mvalue})}

\item{lgnm}{Title of legend.}

\item{width}{Width of bars}

\item{high}{The color name for the high values. The default is \code{red}}

\item{low}{The color name for the high values. The default is \code{green}.
The color names can be vice versa or other colors, depending on the context.}
}
\value{
A \code{ggplot} object, which can be further modified
with \code{ggplot2} functions and themes.
}
\description{
This function plots values corresponding to each month on a rose plot.
}
\examples{
syltmp <- c(18.4, 20.8, 24.3, 26.0, 26.8, 27.6, 28.0, 28.2, 27.9, 26.7, 23.3, 19.7)
year_chart(mvalue = syltmp)
}
\seealso{
\code{\link[=day_chart]{day_chart()}} for plotting values on a day by hours
\code{\link[=week_chart]{week_chart()}} for plotting values in a week by days
\code{\link[=cyclic_chart]{cyclic_chart()}} for plotting values by arbitrary period
}
