% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_it_data.R
\docType{data}
\name{it_data}
\alias{it_data}
\title{Italian Biome extracted data}
\format{
{ An object of class \code{list} of length 12.}
}
\usage{
it_data
}
\description{
The package contains climatic data extracted for the Biomes of Italy.
}
\details{
Returns a 11 data frames and one 'Readme' note. Eight feature
climate data (i.e., one each for the mean and standard deviation of tmax,
tmean, tmin and prec). Within each data frame the columns represent a month
(Jan–Dec), each row represents a feature of the \code{location} \code{sp},
\code{sf} polygon or point object. Values returned are either degrees
Celsius for (tmax, tmean, tmin) or mm (prec). One data frame features
elevation data. Within this data frame, one column shows the mean and the
second the standard deviation. One data frame contains the central latitude
of each feature. One, called "abmt" features the absolute minimum
temperature for each month. For more details on the assignment of Biomes
please refer to Mucina et al. (2023).
}
\examples{
data("it_data", package = "climenv")
head(it_data$abmt)
}
\references{
{ Mucina, L., Divíšek, J., & Tsakalos, J.L. (2023)
Europe, Ecosystems of. In: Encyclopedia of biodiversity, vol X (in print).
\doi{10.1016/B978-0-12-822562-2.00059-1}
}
}
\keyword{datasets}
