% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{media_patch_optimizations}
\alias{media_patch_optimizations}
\title{Edit an existing optimization}
\usage{
media_patch_optimizations(id, name = NULL, runs = NULL)
}
\arguments{
\item{id}{integer required. The optimization ID.}

\item{name}{string optional. The name of the optimization.}

\item{runs}{array optional. An array containing the following fields: 
\itemize{
\item marketId integer, The market ID.
\item startDate string, The start date for the media run.
\item endDate string, The end date for the media run.
\item syscodes array, The syscodes for the media run.
\item rateCards array, The ratecards for the media run.
\item constraints array, The constraints for the media run.
}}
}
\value{
A list containing the following elements:
\item{id}{integer, The optimization ID.}
\item{author}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{name}{string, The name of the optimization.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{finishedAt}{string, The end time of the last run.}
\item{state}{string, The state of the last run.}
\item{lastRunId}{integer, The ID of the last run.}
\item{spotOrderId}{integer, The ID for the spot order produced by the optimization.}
\item{archived}{string, The archival status of the requested object(s).}
\item{reportLink}{string, A link to the visual report for the optimization.}
\item{spotOrderLink}{string, A link to the json version of the spot order.}
\item{fileLinks}{array, Links to the csv and xml versions of the spot order.}
\item{runs}{array, An array containing the following fields: 
\itemize{
\item marketId integer, The market ID.
\item startDate string, The start date for the media run.
\item endDate string, The end date for the media run.
\item syscodes array, The syscodes for the media run.
\item rateCards array, The ratecards for the media run.
\item constraints array, The constraints for the media run.
}}
}
\description{
Edit an existing optimization
}
