% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cinaR.R
\name{cinaR}
\alias{cinaR}
\title{cinaR}
\usage{
cinaR(
  matrix,
  contrasts,
  experiment.type = "ATAC-Seq",
  DA.choice = 1,
  DA.fdr.threshold = 0.05,
  DA.lfc.threshold = 0,
  save.DA.peaks = FALSE,
  DA.peaks.path = NULL,
  norm.method = "cpm",
  filter.method = "custom",
  library.threshold = 2,
  cpm.threshold = 1,
  TSS.threshold = 50000,
  show.annotation.pie = FALSE,
  reference.genome = NULL,
  batch.correction = FALSE,
  batch.information = NULL,
  additional.covariates = NULL,
  sv.number = NULL,
  run.enrichment = TRUE,
  enrichment.method = NULL,
  enrichment.FDR.cutoff = 1,
  background.genes.size = 20000,
  geneset = NULL,
  verbose = TRUE
)
}
\arguments{
\item{matrix}{either bed formatted consensus peak matrix (peaks by 3+samples)
CHR, START, STOP and raw peak counts OR count matrix (genes by 1+samples).}

\item{contrasts}{user-defined contrasts for comparing samples}

\item{experiment.type}{The type of experiment either set to "ATAC-Seq" or "RNA-Seq"}

\item{DA.choice}{determines which pipeline to run:
(1) edgeR, (2) limma-voom, (3) limma-trend, (4) DEseq2.
Note: Use limma-trend if consensus peaks are already normalized, otherwise use other methods.}

\item{DA.fdr.threshold}{fdr cut-off for differential analyses}

\item{DA.lfc.threshold}{log-fold change cutoff for differential analyses}

\item{save.DA.peaks}{saves differentially accessible peaks to an excel file}

\item{DA.peaks.path}{the path which the excel file of the DA peaks will be saved,
if not set it will be saved to current directory.}

\item{norm.method}{normalization method for consensus peaks}

\item{filter.method}{filtering method for low expressed peaks}

\item{library.threshold}{number of libraries a peak occurs so that it is not filtered default set to 2}

\item{cpm.threshold}{count per million threshold for not to filter a peak}

\item{TSS.threshold}{Distance to transcription start site in base-pairs. Default set to 50,000.}

\item{show.annotation.pie}{shows the annotation pie chart produced with ChipSeeker}

\item{reference.genome}{genome of interested species. It should be 'hg38', 'hg19' or 'mm10'.}

\item{batch.correction}{logical, if set will run unsupervised batch correction
via sva (default) or if the batch information is known `batch.information`
argument should be provided by user.}

\item{batch.information}{character vector, given by user.}

\item{additional.covariates}{vector or data.frame, this parameter will be directly added to design
matrix before running the differential analyses, therefore won't affect the batch corrections but
adjust the results in down-stream analyses.}

\item{sv.number}{number of surrogate variables to be calculated using SVA, best left untouched.}

\item{run.enrichment}{logical, turns off enrichment pipeline}

\item{enrichment.method}{There are two methodologies for enrichment analyses,
Hyper-geometric p-value (HPEA) or Geneset Enrichment Analyses (GSEA).}

\item{enrichment.FDR.cutoff}{FDR cut-off for enriched terms, p-values
are corrected by Benjamini-Hochberg procedure}

\item{background.genes.size}{number of background genes for hyper-geometric p-value
calculations. Default is 20,000.}

\item{geneset}{Pathways to be used in enrichment analyses. If not set vp2008 (Chaussabel, 2008)
immune modules will be used. This can be set to any geneset using `read.gmt` function from `qusage`
package. Different modules are available: https://www.gsea-msigdb.org/gsea/downloads.jsp.}

\item{verbose}{prints messages through running the pipeline}
}
\value{
returns differentially accessible peaks
}
\description{
Runs differential analyses and enrichment pipelines
}
\examples{
\donttest{
data(atac_seq_consensus_bm) # calls 'bed'

# a vector for comparing the examples
contrasts <- sapply(strsplit(colnames(bed), split = "-", fixed = TRUE),
                    function(x){x[1]})[4:25]

results <- cinaR(bed, contrasts, reference.genome = "mm10")
}


}
