% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cinaR.R
\name{differentialAnalyses}
\alias{differentialAnalyses}
\title{Differential Analyses}
\usage{
differentialAnalyses(
  final.matrix,
  contrasts,
  experiment.type,
  DA.choice,
  DA.fdr.threshold,
  DA.lfc.threshold,
  save.DA.peaks,
  DA.peaks.path,
  batch.correction,
  batch.information,
  additional.covariates,
  sv.number,
  verbose
)
}
\arguments{
\item{final.matrix}{Annotated Consensus peaks}

\item{contrasts}{user-defined contrasts for comparing samples}

\item{experiment.type}{The type of experiment either set to "ATAC-Seq" or "RNA-Seq"}

\item{DA.choice}{determines which pipeline to run:
(1) edgeR, (2) limma-voom, (3) limma-trend, (4) DEseq2}

\item{DA.fdr.threshold}{fdr cut-off for differential analyses}

\item{DA.lfc.threshold}{log-fold change cutoff for differential analyses}

\item{save.DA.peaks}{logical, saves differentially accessible peaks to an excel file}

\item{DA.peaks.path}{the path which the excel file of the DA peaks will be saved,
if not set it will be saved to current directory.}

\item{batch.correction}{logical, if set will run unsupervised batch correction
via sva (default) or if the batch information is known `batch.information`
argument should be provided by user.}

\item{batch.information}{character vector, given by user.}

\item{additional.covariates}{vector or data.frame, this parameter will be directly added to design
matrix before running the differential analyses, therefore won't affect the batch corrections but
adjust the results in down-stream analyses.}

\item{sv.number}{number of surrogate variables to be calculated using SVA, best left untouched.}

\item{verbose}{prints messages through running the pipeline}
}
\value{
returns consensus peaks (batch corrected version if enabled) and DA peaks
}
\description{
Runs differential analyses pipeline of choice on consensus peaks
}
