% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proofreadEnglishText.R
\name{proofreadEnglishText}
\alias{proofreadEnglishText}
\title{Proofread English Text}
\usage{
proofreadEnglishText(
  Model = "gpt-4o-mini",
  SelectedCode = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{Model}{A string specifying the model to be used for proofreading, defaulting to "gpt-4o-mini".
Currently, "gpt-4", "gpt-4o-mini" and "gpt-4-0613" can be selected as gpt-4 models.
Execution with GPT-4 is recommended.}

\item{SelectedCode}{A logical value indicating whether to read the selected text from the RStudio editor (TRUE) or from the clipboard (FALSE). Defaults to TRUE.}

\item{verbose}{Logical flag to print the progress. Default is TRUE.}
}
\value{
The proofread text, which is also written to the clipboard if SelectedCode is FALSE, or replaces the selected text if SelectedCode is TRUE.
}
\description{
A function to proofread English text or text in different languages during R package development.
It translates the input into English if necessary and returns meticulously checked English text.
}
\details{
Proofread English Text During R Package Development via RStudio API

This function provides a feature to proofread English text during the development of an R package.
It can either take the selected text from the RStudio editor or read from the clipboard, executes the proofreading, and returns the result to the user's clipboard or replaces the selected text.
The user can then paste and check the result if read from the clipboard. The function adheres to R package policies and carefully proofreads the English text.
Execution with GPT-4 is recommended.
}
\examples{
\dontrun{
  # Proofreading selected text in RStudio
  proofreadEnglishText(Model = "gpt-4o-mini", SelectedCode = TRUE)
  # Proofreading text from the clipboard
  proofreadEnglishText(Model = "gpt-4o-mini", SelectedCode = FALSE)
}
}
\author{
Satoshi Kume
}
