% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_DIV.R
\name{calc_DIV}
\alias{calc_DIV}
\title{Calculate daily infection values}
\usage{
calc_DIV(date_time, Tm, RH, rain, dat)
}
\arguments{
\item{date_time}{POSIX_ct, date time the weather recording was taken}

\item{Tm}{numeric, temperature, in Celsius' at time increment in
\code{date_time}}

\item{RH}{numeric, relative humidity (\%) at time increment in \code{date_time}}

\item{rain}{numeric, volume of rain in millimetres recorded between time recordings}

\item{dat}{data.frame, containing column names "times","temp","rh","rain" with
each of the respective arguments for input. provided as a convenience}
}
\value{
data.table, with probability of infection for each day, between 0 and 1
Undertaken with two methods by Wolf and Verreet (2005)
}
\description{
This function calculates the daily infection values for \emph{Cercospora beticola}
on sugar beet. Functions were adapted from Wolf and Verreet (2005)
and Wolf et al (2001)
}
\examples{
date_t <- Sys.time() + seq(0, 179 * 60 * 10, (60 * 10))
Tm <- rnorm(180,20,10)
RH <- runif(180,min = 40,90)
rain <- rbinom(180,1,0.1) * runif(180,0.1,20)

DIV1 <- calc_DIV(
date_time = date_t,
Tm = Tm,
RH = RH,
rain = rain
)
}
\references{
Wolf, P. F. J., and J. A. Verreet. “Factors Affecting the Onset of Cercospora
Leaf Spot Epidemics in Sugar Beet and Establishment of Disease-Monitoring
Thresholds.” \emph{Phytopathology®} 95, no. 3 (March 2005): 269–74.
https://doi.org/10.1094/PHYTO-95-0269.

Wolf, P. F. J., M. Heindl, and J. A. Verreet. “Influence of Sugar Beet Leaf Mass
Development on Predisposition of the Crop to Cercospora Beticola (Sacc.).”
\emph{Journal of Plant Diseases and Protection} 108, no. 6 (2001): 578–92.
}
