% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{bcluster}
\alias{bcluster}
\title{Wrapper function for b-cluster analysis}
\usage{
bcluster(X, inspect = TRUE, inspect.plot = TRUE, algorithm = "n", 
measure = "b", G = NULL, M = NULL, max.iter = 500, X.input = "data", 
tol = exp(-32), runs = 1, seed = 2021)
}
\arguments{
\item{X}{three-way array with \eqn{I} assessors, \eqn{J} products, 
\eqn{M} attributes where CATA data have values \code{0} (not checked) and 
\code{1} (checked)}

\item{inspect}{default (\code{TRUE}) calls the \code{\link[cata]{inspect}}
function to evaluate all solutions (when \code{runs>1})}

\item{inspect.plot}{default (\code{TRUE}) plots results from the 
\code{\link[cata]{inspect}} function}

\item{algorithm}{default is \code{n} for non-hierarchical; \code{h} for 
hierarchical}

\item{measure}{default is \code{b} for the \code{b}-measure; \code{Q} for 
Cochran's Q test}

\item{G}{number of clusters (required for non-hierarchical algorithm)}

\item{M}{initial cluster memberships}

\item{max.iter}{maximum number of iteration allowed (default \code{500})}

\item{X.input}{available only for non-hierarchical algorithm; its value is
either \code{"data"} (default) or \code{"bc"} if \code{X} is
obtained from the function \code{\link[cata]{barray}}}

\item{tol}{non-hierarchical algorithm stops if variance over 5 iterations is
less than \code{tol} (default: \code{exp(-32)})}

\item{runs}{number of runs (defaults to \code{1})}

\item{seed}{for reproducibility (default is \code{2021})}
}
\value{
list with elements:
\itemize{
\item{\code{runs} : b-cluster analysis results from \code{\link[cata]{bcluster.n}} 
or \code{\link[cata]{bcluster.h}} (in a list if \code{runs>1})}
\item{\code{inspect} : result from \code{\link[cata]{inspect}} (the plot from 
this function is rendered if \code{inspect.plot} is \code{TRUE})}}
}
\description{
By default, \code{bcluster} calls a function to perform b-cluster analysis 
by a non-hierarchical iterative ascent algorithm, then inspects results if 
there are multiple runs.
}
\examples{
data(bread)

# b-cluster analysis on the first 8 consumers and the first 5 attributes
(b1 <- bcluster(bread$cata[1:8,,1:5], G=2, seed = 123))
# Since the seed is the same, the result will be identical to
# (b2 <- bcluster.n(bread$cata[1:8,,1:5], G=2, seed = 123))
b3 <- bcluster(bread$cata[1:8,,1:5], G=2, runs = 5, seed = 123)
}
\references{
Castura, J.C., Meyners, M., Varela, P., & Næs, T. (2022). 
Clustering consumers based on product discrimination in check-all-that-apply 
(CATA) data. \emph{Food Quality and Preference}, 104564. 
\doi{10.1016/j.foodqual.2022.104564}.
}
\author{
J.C. Castura
}
