% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradLinkTypoLayer.R
\name{gradLinkTypoLayer}
\alias{gradLinkTypoLayer}
\title{Graduated and Colored Links Layer}
\usage{
gradLinkTypoLayer(x, df, xid = NULL, dfid = NULL, var,
  breaks = getBreaks(v = df[, var], nclass = 4, method = "quantile"),
  lwd = c(1, 2, 4, 6), var2, col = NULL, colNA = "white",
  legend.title.cex = 0.8, legend.values.cex = 0.6,
  legend.values.rnd = 0, legend.var.pos = "bottomleft",
  legend.var.title.txt = var, legend.var.frame = FALSE,
  legend.var2.pos = "topright", legend.var2.title.txt = var2,
  legend.var2.values.order = NULL, legend.var2.nodata = "no data",
  legend.var2.frame = FALSE, add = TRUE, spdf, spdfid, spdfids,
  spdfide, dfids, dfide)
}
\arguments{
\item{x}{an sf object, a simple feature collection.}

\item{df}{a data frame that contains identifiers of starting and ending points and variables.}

\item{xid}{identifier fields in x, character 
vector of length 2, default to the 2 first columns. (optional)}

\item{dfid}{identifier fields in df, character 
vector of length 2, default to the two first columns. (optional)}

\item{var}{name of the variable used to plot the links widths.}

\item{breaks}{break values in sorted order to indicate the intervals for assigning the lines widths.}

\item{lwd}{vector of widths (classes of widths).}

\item{var2}{name of the variable used to plot the links colors.}

\item{col}{color of the links.}

\item{colNA}{no data color.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.values.rnd}{number of decimal places of the values in 
the legend.}

\item{legend.var.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{legend.var.title.txt}{title of the legend (numeric data).}

\item{legend.var.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{legend.var2.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{legend.var2.title.txt}{title of the legend (factor data).}

\item{legend.var2.values.order}{values order in the legend, a character vector 
that matches var modalities. Colors will be affected following this order.}

\item{legend.var2.nodata}{text for "no data" values}

\item{legend.var2.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}

\item{spdf}{defunct.}

\item{spdfid}{defunct.}

\item{spdfids}{defunct.}

\item{spdfide}{defunct.}

\item{dfids}{defunct.}

\item{dfide}{defunct.}
}
\description{
Plot a layer of colored and graduated links. 
Links are plotted according to discrete classes of widths. 
Colors depend on a discrete variable of categories.
}
\note{
Unlike most of cartography functions, identifiers fields are mandatory.
}
\examples{
library(sp)
data("nuts2006")
# Create a link layer
twincities.spdf <- getLinkLayer(x = nuts2.spdf, df = twincities.df)

# Plot the links - Twin cities agreements between regions
plot(nuts0.spdf, col = "grey60",border = "grey20")

# Countries of agreements
twincities.df$ctry <- substr(twincities.df$j,1,2)

# Agreements with german cities
twincitiesok <- twincities.df[substr(twincities.df$i,1,2)=="DE",]

# plot the colored and graduated links
gradLinkTypoLayer(x = twincities.spdf, df = twincitiesok,
                  var = "fij", breaks = c(5,10,15,20), 
                  lwd = c(1,4,8),
                  var2 = "ctry",  add = TRUE)
}
\seealso{
\link{getLinkLayer}, \link{propLinkLayer}, \link{legendGradLines}, \link{gradLinkLayer}
}
