% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFigDim.R
\name{getFigDim}
\alias{getFigDim}
\title{Get Figure Dimensions}
\usage{
getFigDim(spdf, width = NULL, height = NULL, mar = par()$mar, res = 72)
}
\arguments{
\item{spdf}{a Spatial*DataFrame.}

\item{width}{width of the figure (in pixels), either width or height 
must be set.}

\item{height}{heigth of the figure (in pixels), either width or height 
must be set.}

\item{mar}{a numerical vector of the form c(bottom, left, top, right) 
which gives the number of lines of margin to be specified on the four 
sides of the plot (see \link{par}).}

\item{res}{the nominal resolution in ppi which will be recorded in the 
bitmap file.}
}
\value{
A vector of width and height in pixels is returned.
}
\description{
Give the dimension of a map figure to be exported in 
raster of vector format. \cr
Output dimension are based on a Spatial*DataFrame 
dimension ratio, the margins of the figure, a targeted width or height
of the figure and its resolution.
}
\details{
The function can be used to export vector or raster files (see examples).
}
\examples{
\dontrun{
data("nuts2006")
spdf <- nuts0.spdf[nuts0.spdf$id=="IT",]
## PNG export
# get figure dimension
sizes <- getFigDim(spdf = spdf, width = 450, mar = c(0,0,1.2,0))
# export the map
png(filename = "Italy.png", width = sizes[1], height = sizes[2])
par(mar = c(0,0,1.2,0))
plot(spdf, col  = NA, border=NA, bg = "#A6CAE0")
plot(world.spdf, col  = "#E3DEBF", border=NA, add=TRUE)
plot(spdf, col  = "#D1914D", border="white", add=T)
layoutLayer(title = "Map of Italy")
dev.off()

## PDF export
# get figure dimension
sizes <- getFigDim(spdf = spdf, width = 450, mar = c(1,1,2.2,1))
# export the map
pdf(file = "Italy.pdf", width = sizes[1]/72, height = sizes[2]/72)
par(mar = c(1,1,2.2,1))
plot(spdf, col  = NA, border=NA, bg = "#A6CAE0")
plot(world.spdf, col  = "#E3DEBF", border=NA, add=TRUE)
plot(spdf, col  = "#D1914D", border="white", add=T)
layoutLayer(title = "Map of Italy")
dev.off()
}
}

