\name{DoptBCD.sim}
\alias{DoptBCD.sim}
\title{
Atkinson's \eqn{D_A}-optimal Biased Coin Design with Covariate Data Generating Mechanism
}
\description{
Allocates patients generated by simulating covariates-profile under the assumption of independence between covariates and levels within each covariate, to one of two treatments based on the \eqn{D_A}-optimal biased coin design in the presence of prognostic factors, as proposed by Atkinson A C (1982) <Doi:10.2307/2335853>.
}
\usage{
DoptBCD.sim(n = 1000, cov_num = 2, level_num = c(2, 2), 
            pr = rep(0.5, 4))
}
\arguments{
  \item{n}{the number of patients. Default is \code{1000}.}
  \item{cov_num}{the number of covariates. Default is \code{2}.}
  \item{level_num}{the vector of level numbers for each covariate. Hence the length of \code{level_num} should be equal to the number of covariates. The default is \code{c(2, 2)}. }
  \item{pr}{the vector of probabilities. Under the assumption of independence between covariates, \code{pr} is a vector containing probabilities for each level of each covariate. The length of \code{pr} should correspond to number of all levels, and the vector sum of \code{pr} should be equal to \code{cov_num}. The default is \code{pr = rep(0.5, 4)}, which implies that \code{cov_num = 2}, and \code{level_num = c(2, 2)}.}
}
\details{
See \code{\link{DoptBCD}}.
}
\value{
See \code{\link{DoptBCD}}. 
}
\references{
Atkinson A C. \emph{Optimum biased coin designs for sequential clinical trials with prognostic factors}[J]. Biometrika, 1982, 69(1): 61-67.
}
\seealso{
See \code{\link{DoptBCD}} for allocating patients with complete covariate data; See \code{\link{DoptBCD.ui}} for the command-line user interface. 
}