% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simul_data}
\alias{simul_data}
\title{Simulate Covariates and Progression Free Survival Data}
\usage{
simul_data(n, add_interaction = FALSE, coefs, ...)
}
\arguments{
\item{n}{(\code{count})\cr number of patients.}

\item{add_interaction}{(\code{flag})\cr whether to add interaction terms between covariates
1 and 2.}

\item{coefs}{(\code{numeric})\cr named vector of coefficients to set.}

\item{\dots}{additional parameters apart from the linear predictor values
needed for \code{\link[=simul_pfs]{simul_pfs()}}.}
}
\value{
A combined \code{data.frame} with the \code{id} column, the design matrix and the
PFS outcomes.
}
\description{
This combines the covariates simulation via \code{\link[=simul_covariates]{simul_covariates()}} with 10
categorical covariates, and the PFS simulation via \code{\link[=simul_pfs]{simul_pfs()}}.
}
\details{
Regression coefficients are for an AFT with over-parametrized dummy
coding for arm-subgroup interactions.
}
\examples{
set.seed(321)
simul_data(
  n = 100,
  coefs = c(arm1 = 1),
  sigma_aft = 1,
  recr_duration = 0.2,
  rate_cens = 2,
  n_events = 20
)
}
