% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gera.bn.pa.R
\name{gera.bn.pa}
\alias{gera.bn.pa}
\title{Learn the Bayesian Network and Path Analysis}
\usage{
gera.bn.pa(data_bn, bn.learn.algorithms, wl = "", bl = "",
  nreplicates = 100)
}
\arguments{
\item{data_bn}{is a data frame containing the variables from which the Bayesian Networks structure will be learned.}

\item{bn.learn.algorithms}{is a list of algorithms (present in bnlearn) to be used in Bayesian Networks structure learning pocess.}

\item{wl}{is a list with a couple of variables to build the white list (mandatory nodes of BN).}

\item{bl}{is a list with a couple of variables to build the black list (forbidden nodes of BN).}

\item{nreplicates}{is the size of each Bayesian Network bootstrap replicate.}
}
\value{
NULL.
}
\description{
This function learn the Bayesian Network from the dataset and builds a Path Analysis model.
}
\details{
This function receives a dataset, a list of algorithms, a list of required nodes, a list of forbidden nodes
and the number of replicates the bootstrap process will execute as parameters. Then the function identify
the type of variable and convert it to numeric if necessary, then learn the Bayesian Network structure with
one or more Bayesian Networks structure learn algorithm, learn the Bayesian Networks parameters and build the Path Analysis model. Finally it
exports a Bayesian Networks / Path Analysis graph figure and text file with Bayesian Networks / Path Analysis parameters.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Load packages
library(bnpa)
# Show datasets
data1<-dataQuantC # Pre-Loaded
data2<-dataQualiN # Pre-Loaded
head(data1)
head(data2)
# Set a dataset to work
data.to.work <- data1
# Transform some variables into integer types
data.to.work$A<-as.integer(data.to.work$A)
data.to.work$C<-as.integer(data.to.work$C)
data.to.work$E<-as.integer(data.to.work$E)
data.to.work$G<-as.integer(data.to.work$G)
# Creates a white and black list empty
wl=""
bl=""
# Set what Bayesian Networks learning algorithms will be used
bn.learn.algorithms <- c("hc", "rsmax2")
# Learn a Bayesian Networks structure from data to work and builds a Path Analysis model
bn.pa<-gera.bn.pa(data.to.work, bn.learn.algorithms)
}
\author{
Elias Carvalho
}

