% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.types.R
\name{check.types}
\alias{check.types}
\title{Verify types of variable.}
\usage{
check.types(data.to.work, message = 0)
}
\arguments{
\item{data.to.work}{is a data frame containing the variables to be verified.}

\item{message}{is a parameter indicating if the function will or not show a message.}
}
\value{
A variable with the code indicating the type of variable and a message (or not).
}
\description{
Verify what are the types of variables the dataset has.
}
\details{
This function receives a dataset as parameter and check each type of variable returning a number indicating the type oa variables. 
The variables can be 1=integer, 2=numeric, 3=factor, 4=integer and numeric, 5=integer and  factor, 6=numeric and factor or 7=integer, numeric and factor.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Load packages
library(bnpa)
# Use working datasets from package
data.to.work <- dataQuantC
head(data.to.work)
####################################################################################
# check.types.R - Verify types of variable.
####################################################################################
#Check and return a numeric value
check.types(data.to.work, message = 1)
# Adding random data to data.to.work, function will return TRUE
data.to.work$Z <- round(runif(500, min=0, max=1000),2)
# Converting the numeric variable into factor
data.to.work$Z <- factor(data.to.work$Z)
# Check and return a numeric value correspondig to: 1=integer, 2=numeric, 3=factor, 4=integer and
# numeric, 5=integer and  factor, 6=numeric and factor or 7=integer, numeric and factor.
check.types(data.to.work, message = 1)
# Supressing the message
check.types(data.to.work, message = 0)
}
\author{
Elias Carvalho
}

