% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{build_site}
\alias{build_site}
\title{Build a website}
\usage{
build_site(local = FALSE, method = c("html", "custom"), run_hugo = TRUE)
}
\arguments{
\item{local}{Whether to build the website locally to be served via
\code{\link{serve_site}()}.}

\item{method}{Different methods to build a website (each with pros and cons).
See Details. The value of this argument will be obtained from the global
option \code{getOption('blogdown.method')} when it is set.}

\item{run_hugo}{Whether to run \code{hugo_build()} after R Markdown files are
compiled.}
}
\description{
Compile all Rmd files and build the site through Hugo.
}
\details{
You can use \code{\link{serve_site}()} to preview your website locally, and
\code{build_site()} to build the site for publishing.

For the \code{method} argument: \code{method = "html"} means to render all
Rmd files to HTML via \code{rmarkdown::\link[rmarkdown]{render}()} (which
means Markdown is processed through Pandoc), and process the paths of
external dependencies generated from R code chunks, including images and HTML
dependencies.

For all rendering methods, a custom R script \file{R/build.R} will be
executed if you have provided it under the root directory of the website
(e.g. you can compile Rmd to Markdown through
\code{knitr::\link[knitr]{knit}()} and build the side via
\code{\link{hugo_cmd}()}). \code{method = "custom"} means it is entirely up
to this R script how a website is rendered. The script is executed via
command line \command{Rscript "R/build.R"}, which means it is executed in a
separate R session. The value of the argument \code{local} is passed to the
command line (you can retrieve the command-line arguments via
\code{\link{commandArgs}(TRUE)}). For \code{method = "html"}, the R script
\file{R/build2.R} (if exists) will be executed after Hugo has built the site.
This can be useful if you want to post-process the site.
}
\note{
This function recompiles all R Markdown files by default, even if the
  output files are newer than the source files. If you want to build the site
  without rebuilding all R Markdown files, you should use
  \code{\link{hugo_build}()} instead.
}
