% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pam_helpers.R
\name{files_2data}
\alias{files_2data}
\title{Creates a data.frame of species' references from files in a directory}
\usage{
files_2data(path, format, spdf_grid = NULL, parallel = FALSE, n_cores = NULL)
}
\arguments{
\item{path}{(character) full path name of directory containing raster,
shapefiles, geopackage, or GeoJSON files representing species geographic
ranges. Each file must be named as the species that it represents. All files
must be in the same format. If files are raster, values in each layer must be
1 (presence) and 0 (absence).}

\item{format}{(character) the format files found in \code{path}. Current
available formats are: "shp", "gpkg", "geojson", "GTiff", and "ascii".}

\item{spdf_grid}{geographic grid for the region of interest (output of
function \code{\link{grid_from_region}}). Used when format equals "shp" or
"gpkg". Default = NULL.}

\item{parallel}{(logical) whether to perform analyses in parallel.
Default = FALSE.}

\item{n_cores}{(numeric) number of cores to be used when \code{parallel} =
TRUE. The default, NULL, uses available cores - 1.}
}
\value{
If files are in raster format, a data.frame of species geographic records
derived from values of presence in each layer.

If files are not in raster format, a data.frame of species' found in distinct
positions (defined with identifiers); includes two columns: "ID" and
"Species".
}
\description{
Creates a data.frame of species' references that contains
longitude, latitude, and species name, from a character.
}
\examples{
\donttest{
# Data for examples
data("mx", package = "biosurvey")
data("species_data", package = "biosurvey")

# Saving species data in a temporal directory
tdir <- file.path(tempdir(), "testbio")
dir.create(tdir)

namessp <- paste0("species_", 1:length(species_data))


for (i in 1:length(species_data)) {
  rgdal::writeOGR(species_data[i, ], dsn = tdir, layer = namessp[i],
                  driver = "ESRI Shapefile")
}

# Preparing grid for analysis
grid_reg <- grid_from_region(region = mx, cell_size = 100)

# Running analysis with data from directory
sp_data <- files_2data(path = tdir, format = "shp", spdf_grid = grid_reg)
}
}
