% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_LBM_Binary_functions.R
\name{BinBlocRnd_LBM}
\alias{BinBlocRnd_LBM}
\title{BinBlocRnd_LBM function for binary data matrix simulation}
\usage{
BinBlocRnd_LBM(n,J,theta)
}
\arguments{
\item{n}{a positive integer specifying the number of expected rows.}

\item{J}{a positive integer specifying the number of expected columns.}

\item{theta}{a list specifying the model parameters:

\code{pi_g}: a vector specifying the row mixing proportions.

\code{rho_h}: a vector specifying the matrix column mixing proportions.

\code{alpha_gh}: a matrix specifying the distribution parameter of the matrix.}
}
\value{
a list including the arguments:

\code{x}: simulated  data matrix.

\code{xrow}: numeric vector specifying row partition.

\code{xcol}: numeric vector specifying  column partition.
}
\description{
Produce a data matrix generated under the Binary Latent Block Model.
}
\examples{
require(bikm1)
##' set.seed(42)
n=200
J=120
g=3
h=2
theta=list()
theta$pi_g=1/g *matrix(1,g,1)
theta$rho_h=1/h *matrix(1,h,1)
theta$alpha_gh=matrix(runif(6),ncol=h)
data=BinBlocRnd_LBM(n,J,theta)

}
