% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigtcr_func.R
\name{get.pval}
\alias{get.pval}
\title{Comparison of CCIF}
\usage{
get.pval(obs.y, event, tau = Inf, comp.event = c(1, 2), np = 1000,
  Kt = function(x) {     1 })
}
\arguments{
\item{obs.y}{\eqn{Y}: time to failure events or censoring}

\item{event}{0: censored; \eqn{1, \ldots J}: type of failure events}

\item{tau}{Conditioning time \eqn{\tau} under which the CCIF is defined}

\item{comp.event}{Failure events for CCIF comparison}

\item{np}{Number of permutations}

\item{Kt}{A weight function that takes one parameter \eqn{t} and return the
weight for \eqn{t}. Default weight function is constant \eqn{1}}
}
\value{
P-value of the hypothesis test \eqn{H_0: G_j = G_k = \ldots = G_l}.
}
\description{
Compare the CCIF of different failure typess by applying the technique of
permutation test. See \code{\link{bigtcr-package}}.
}
\examples{

pval <- get.pval(pancancer$obs.y, pancancer$min.type,
                 tau=120, comp.event=c(1,2), np=20);

}

