% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigtcr_func.R
\name{get.ccif}
\alias{get.ccif}
\title{Conditional Cumulative Incidence Function (CCIF) Estimation}
\usage{
get.ccif(obs.y, event, tau = Inf)
}
\arguments{
\item{obs.y}{\eqn{Y}: time to failure events or censoring}

\item{event}{0: censored; \eqn{1, \ldots J}: type of failure events}

\item{tau}{Conditioning time \eqn{\tau} under which the CCIF is defined}
}
\value{
A matrix with class ccif that has \eqn{J} columns. Columns 1 to \eqn{J} correspond to
\eqn{G_1(t)} to \eqn{G_J(t)}. Each row represents a distinct observed time
point \eqn{t} and the row name contains the value of \eqn{t}.
}
\description{
Estimate the conditional cumulative incidence function. See \code{\link{bigtcr-package}}.
}
\examples{

Gj <- get.ccif(obs.y = pancancer$obs.y, event = pancancer$min.type, tau   = 120);

}

