% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_bigergm.R
\name{gof_bigergm}
\alias{gof_bigergm}
\title{Goodness of fit statistics for HERGM}
\usage{
gof_bigergm(
  net,
  data_for_simulation,
  list_feature_matrices,
  colname_vertex_id,
  colname_block_membership,
  bigergm_results,
  type = "full",
  ergm_control = ergm::control.simulate.formula(),
  seed = NULL,
  n_sim = 1,
  prevent_duplicate = TRUE,
  compute_geodesic_distance = FALSE,
  start_from_observed = FALSE,
  ...
)
}
\arguments{
\item{net}{the target network}

\item{data_for_simulation}{a dataframe with node-level covariates}

\item{list_feature_matrices}{a list of feature adjacency matrices}

\item{colname_vertex_id}{the name of the column that contains the node id}

\item{colname_block_membership}{the name o the column that contains the block affiliation of each node}

\item{bigergm_results}{a bigergm results object}

\item{type}{the type of evaluation to perform. Can take the values \code{full} or \code{within}. \code{full} performs the evaluation on all edges, and \code{within} only considers within-block edges.}

\item{ergm_control}{MCMC parameters as an instance of ergm.control}

\item{seed}{the seed to be passed to simulate_hergm}

\item{n_sim}{the number of simulations to employ for calculating goodness of fit}

\item{prevent_duplicate}{see \code{simulate_hergm}}

\item{compute_geodesic_distance}{if \code{TRUE}, the distribution of geodesic distances is also computed (considerably increases computation time on large networks. \code{FALSE} by default.)}

\item{start_from_observed}{if \code{TRUE}, MCMC uses the observed network as a starting point}

\item{...}{Additional arguments, to be passed to lower-level functions}
}
\value{
\code{\link{gof_bigergm}} returns a list with two entries.
The first entry 'original' is another list of the network stats, degree distribution, edgewise-shared partner distribution, and geodesic distance distribution (if \code{compute_geodesic_distance = TRUE}) of the observed network.
The second entry is called 'simulated' is also list compiling the network stats, degree distribution, edgewise-shared partner distribution, and geodesic distance distribution (if \code{compute_geodesic_distance = TRUE}) of all simulated networks.
}
\description{
Goodness of fit statistics for HERGM
}
\examples{
data(toyNet)
\donttest{
# Specify the model that you would like to estimate.
model_formula <- toyNet ~ edges + nodematch("x") + nodematch("y") + triangle
# Estimate the model
nodes_data <- data.frame(
  node_id = 1:toyNet$gal$n,
  x = toyNet \%v\% "x",
  y = toyNet \%v\% "y",
  block = toyNet \%v\% "block"
)
list_feature_matrices <- bigergm::get_list_sparse_feature_adjmat(toyNet, model_formula)
estimate <- hergm(model_formula,n_clusters = 4)
gof_res <- bigergm::gof_bigergm(
  toyNet,
  list_feature_matrices = list_feature_matrices,
  data_for_simulation = nodes_data,
  colname_vertex_id = "node_id",
  colname_block_membership = "block",
  bigergm_results = estimate,
  n_sim = 100
)
}

}
