% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{mdlfit.gfx}
\alias{mdlfit.gfx}
\title{Graphical presentation of model fit for the Beta-Binomial classification accuracy and consistency model.}
\usage{
mdlfit.gfx(x)
}
\arguments{
\item{x}{The output object from the \code{LL.CA()}, \code{LL.MC.CA()}, \code{HB.CA()}, or \code{HB.CA.MC()} functions.}
}
\description{
Tool for visually gauging the discrepancy between the observed and model-implied frequencies of observed-scores.
}
\examples{
# Generate some data. 1000 respondents taking 100 item test:
set.seed(060121)
p.success <- rBeta.4P(1000, 0.25, 0.75, 5, 3)
for (i in 1:100) {
  if (i == 1) {
   rawdata <- matrix(nrow = 1000, ncol = 100)
 }
 rawdata[, i] <- rbinom(1000, 1, p.success)
}

# Analyse the accuracy and consistency of the test and store the object:
out <- LL.CA(x = rowSums(rawdata), reliability = cba(rawdata), cut = 50,
min = 0, max = 100, modelfit = c(nbins = 20, minbin = 1))

# Feed the object to the mdlfit.gfx() function:
mdlfit.gfx(out)
}
