% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{AUC}
\alias{AUC}
\title{Area Under the ROC Curve.}
\usage{
AUC(FPR, TPR)
}
\arguments{
\item{FPR}{Vector of False-Positive Rates.}

\item{TPR}{Vector of True-Positive Rates.}
}
\value{
A value representing the area under the ROC curve.
}
\description{
Given a vector of false-positive rates and a vector of true-positive rates, calculate the area under the Receiver Operator Characteristic (ROC) curve.
}
\note{
Script originally retrieved and modified from https://blog.revolutionanalytics.com/2016/11/calculating-auc.html.
}
\examples{
# Generate some fictional data. Say, 100 individuals take a test with a
# maximum score of 100 and a minimum score of 0.
set.seed(1234)
testdata <- rbinom(100, 100, rBeta.4P(100, 0.25, 0.75, 5, 3))
hist(testdata, xlim = c(0, 100))

# Suppose the cutoff value for attaining a pass is 50 items correct, and
# that the reliability of this test was estimated to 0.7. To calculate the
# necessary (x, y) coordinates to compute the area under the curve statistic
# one can use the LL.ROC() function with the argument
# raw.out = TRUE.
coords <- LL.ROC(x = testdata, reliability = .7, truecut = 50, min = 0,
max = 100, raw.out = TRUE)

# To calculate and retrieve the Area Under the Curve (AUC) with the AUC()
# function, feed it the raw coordinates calculated above.
AUC(coords[, "FPR"], coords[, "TPR"])
}
