% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayou-custommodel-input.R
\name{plotBranchHeatMap}
\alias{plotBranchHeatMap}
\title{A function to plot a heatmap of reconstructed parameter values on the branches of the tree}
\usage{
plotBranchHeatMap(tree, chain, variable, burnin = 0, nn = NULL,
  pal = heat.colors, legend_ticks = NULL, legend_settings = list(plot =
  TRUE), ...)
}
\arguments{
\item{tree}{A phylogenetic tree}

\item{chain}{A bayou MCMC chain}

\item{variable}{The parameter to reconstruct across the tree}

\item{burnin}{The initial proportion of burnin samples to discard}

\item{nn}{The number of discrete categories to divide the variable into}

\item{pal}{A color palette function that produces nn colors}

\item{legend_ticks}{The sequence of values to display a legend for}

\item{legend_settings}{A list of legend attributes (passed to bayou:::.addColorBar)}

\item{...}{Additional options passed to plot.phylo}
}
\description{
A function to plot a heatmap of reconstructed parameter values on the branches of the tree
}
\details{
legend_settings is an optional list of any of the following:

legend - a logical indicating whether a legend should be plotted

x - the x location of the legend

y - the y location of the legend

height - the height of the legend

width - the width of the legend

n - the number of gradations in color to plot from the palette

adjx - an x adjustment for placing text next to the legend bar

cex.lab - the size of text labels next to the legend bar

text.col - The color of text labels

locator - if TRUE, then x and y coordinates are ignored and legend is placed
interactively.
}
