% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdpnormal.R
\name{bdpnormal}
\alias{bdpnormal}
\alias{bdpnormal,ANY-method}
\title{Bayesian Discount Prior: Gaussian mean values}
\usage{
bdpnormal(mu_t = NULL, sigma_t = NULL, N_t = NULL, mu0_t = NULL,
  sigma0_t = NULL, N0_t = NULL, mu_c = NULL, sigma_c = NULL,
  N_c = NULL, mu0_c = NULL, sigma0_c = NULL, N0_c = NULL,
  alpha_max = 1, weibull_scale = 0.135, weibull_shape = 3,
  number_mcmc = 10000, two_side = 1)
}
\arguments{
\item{mu_t}{scalar. Mean of the current treatment group.}

\item{sigma_t}{scalar. Standard deviation of the current treatment group.}

\item{N_t}{scalar. Number of observations of the current treatment group.}

\item{mu0_t}{scalar. Mean of the historical treatment group. Required
for single arm (OPC) trials.}

\item{sigma0_t}{scalar. Standard deviation of the historical treatment
group. Required for single arm (OPC) trials.}

\item{N0_t}{scalar. Number of observations of the historical treatment
group. Required for single arm (OPC) trials.}

\item{mu_c}{scalar. Mean of the current control group. Required for
two arm (RCT) trials.}

\item{sigma_c}{scalar. Standard deviation of the current control group.
Required for two arm (RCT) trials.}

\item{N_c}{scalar. Number of observations of the current control group.
Required for two arm (RCT) trials.}

\item{mu0_c}{scalar. Mean of the historical control group.}

\item{sigma0_c}{scalar. Standard deviation of the historical control group.}

\item{N0_c}{scalar. Number of observations of the historical control group.}

\item{alpha_max}{scalar. Maximum weight the discount function can apply.
Default is 1. For a two-arm trial, users may specify a vector of two values
where the first value is used to weight the historical treatment group and
the second value is used to weight the historical control group.}

\item{weibull_scale}{scalar. Scale parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 0.135. Two values have special treatment: 0 and Inf. For
weibull_scale = 0, alpha is set to 0, i.e., no weight. For
weibull_scale = Inf, alpha is set to 1, i.e., full weight. For a two-arm
trial, users may specify a vector of two values where the first value is
used to estimate the weight of the historical treatment group and the
second value is used to estimate the weight of the historical control
group.}

\item{weibull_shape}{scalar. Shape parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 3. For a two-arm trial, users may specify a vector of two values
where the first value is used to estimate the weight of the historical
treatment group and the second value is used to estimate the weight of the
historical control group.}

\item{number_mcmc}{scalar. Number of Markov Chain Monte Carlo (MCMC)
simulations. Default is 10000.}

\item{two_side}{scalar. Indicator of two-sided test for the discount
function. Default value is 1.}
}
\value{
\code{bdpnormal} returns an object of class "bdpnormal".
The functions \code{\link{summary}} and \code{\link{print}} are used to obtain and
print a summary of the results, including user inputs. The \code{\link{plot}}
function displays visual outputs as well.

An object of class \code{bdpnormal} is a list containing at least
the following components:
\describe{
 \item{\code{posterior_treatment}}{
   list. Entries contain values related to the treatment group:}
   \itemize{
     \item{\code{alpha_discount}}{
       numeric. Alpha value, the weighting parameter of the historical data.}
     \item{\code{pvalue}}{
       numeric. The posterior probability of the stochastic comparison
       between the current and historical data.}
     \item{\code{mu_posterior}}{
       vector. The posterior of the treatment group, incorporating the
       weighted historical data.}
     \item{\code{mu_posterior_flat}}{
       vector. The distribution of the current treatment group, i.e., no
       incorporation of the historical data.}
     \item{\code{mu_prior}}{
       vector. The distribution of the historical treatment group.}
  }
 \item{\code{posterior_control}}{
   list. Similar entries as \code{posterior_treament}. Only present if
   control group is specified.}
 \item{\code{f1}}{
   list. Entries contain values related to the posterior effect:}
   \itemize{
     \item{\code{density_post_treatment}}{
       object of class \code{density}. Used internally to plot the density of
       the treatment group posterior.}
     \item{\code{density_flat_treatment}}{
       object of class \code{density}. Used internally to plot the density of
       the treatment group "flat" distribution.}
     \item{\code{density_prior_treatment}}{
       object of class \code{density}. Used internally to plot the density of
       the treatment group prior.}
     \item{\code{density_post_control}}{
       object of class \code{density}. Used internally to plot the density of
       the control group (if present) posterior.}
     \item{\code{density_flat_control}}{
       object of class \code{density}. Used internally to plot the density of
       the control group (if present) "flat" distribution.}
     \item{\code{density_prior_control}}{
       object of class \code{density}. Used internally to plot the density of
       the control group (if present) prior.}
     \item{\code{TestMinusControl_post}}{
       vector. If control group is present, vector contains posterior
       distribution of the effect estimate of treatment vs. control.
       control groups.}
  }
 \item{\code{args1}}{
   list. Entries contain user inputs. In addition, the following elements
   are ouput:}
   \itemize{
     \item{\code{arm2}}{
       binary indicator. Used internally to indicate one-arm or two-arm
       analysis.}
     \item{\code{intent}}{
       character. Denotes current/historical status of treatment and
       control groups.}
  }
}
}
\description{
\code{bdpnormal} is used for estimating posterior samples from a
  Gaussian outcome where an informative prior is used. The prior weight
  is determined using a discount function. This code is modeled after
  the methodologies developed in Haddad et al. (2017).
}
\details{
\code{bdpnormal} uses a two-stage approach for determining the
  strength of historical data in estimation of a mean outcome.  In the first
  stage, a Weibull distribution function is used as a
  \emph{discount function} that defines the maximum strength of the
  historical data (via \code{weibull_shape}, \code{weibull_scale}, and
  \code{alpha_max}) and discounts based on disagreement with the current data.
  Disagreement between current and historical data is determined by stochastically
  comparing the respective posterior distributions under noninformative priors.
  With Gaussian data, the comparison is the proability (\code{p}) that the current
  mean is less than the historical mean. The comparison metric \code{p} is then
  input into the Weibull discount function and the final strength of the
  historical data is returned (alpha).

 In the second stage, posterior estimation is performed where the discount
 function parameter, \code{alpha}, is used as a fixed value for all posterior
 estimation procedures.

 To carry out a single arm (OPC) analysis, data for the current treatment
 (\code{mu_t}, \code{sigma_t}, and \code{N_t}) and historical treatment
 (\code{mu0_t}, \code{sigma0_t}, and \code{N0_t}) must be input. The results
 are then based on the posterior distribution of the current data augmented
 by the historical data.

 To carry our a two-arm (RCT) analysis, data for the current treatment and
 current control (\code{mu_c}, \code{sigma_c}, and \code{N_c}) must be input,
 as well as at least one of the historical treatment and historical control
 (\code{mu0_c}, \code{sigma0_c}, and \code{N0_c}). The results
 are then based on the posterior distribution of the difference between
 current treatment and control, augmented by available historical data.
}
\examples{
# One-arm trial (OPC) example
fit <- bdpnormal(mu_t = 30, sigma_t = 10, N_t = 250,
                 mu0_t = 50, sigma0_t = 5, N0_t = 250)
summary(fit)
#plot(fit)

# Two-arm (RCT) example
fit2 <- bdpnormal(mu_t = 30, sigma_t = 10, N_t = 250,
                  mu0_t = 50, sigma0_t = 5, N0_t = 250,
                  mu_c = 25, sigma_c = 10, N_c = 250,
                  mu0_c = 50, sigma0_c = 5, N0_c = 250)
summary(fit2)
#plot(fit2)

}
\references{
Haddad, T., Himes, A., Thompson, L., Irony, T., Nair, R. MDIC Computer
  Modeling and Simulation working group.(2017) Incorporation of stochastic
  engineering models as prior information in Bayesian medical device trials.
  \emph{Journal of Biopharmaceutical Statistics}. To Appear.
}
