% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_medical_entities.R
\name{detect_medical_entities}
\alias{detect_medical_entities}
\title{Detect named entities in a source medical text}
\usage{
detect_medical_entities(text, language = "en", version = c("2", "1"), ...)
}
\arguments{
\item{text}{A character string containing a text to entities analyze, or a character vector to perform analysis separately for each element.}

\item{language}{A character string containing a two-letter language code. Currently only \dQuote{en} is supported.}

\item{version}{A character string containing the version of the API that should be used. Currently only "1" or "2" are supported.}

\item{\dots}{Additional arguments passed to \code{\link{comprehendHTTP}}.}
}
\value{
A data frame
}
\description{
Detect entities in a source medical text
}
\examples{
\dontrun{
  # simple example
  medical_detect_entities("Mrs. Smith comes in today complaining of shortness of breath.")
  
  txt <-c("Mrs. Smith comes in today.",
          "She is complaining of shortnesss of breath.")
  medical_detect_entities(txt)
}
}
