% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criterionFit.R
\name{criterionFit}
\alias{criterionFit}
\title{Minimize criterion (AIC or BIC)}
\usage{
criterionFit(thetaList, X, z, A, BIC, logLike, constraint, thetaInds,
  innerIndices)
}
\arguments{
\item{thetaList}{a list of coefficient values (probably from a LASSO path)}

\item{X}{a design matrix}

\item{z}{response matrix (for multinomial or logistic data)}

\item{A}{a list of adjacency matrices}

\item{BIC}{logical, use BIC if true or AIC if false}

\item{logLike}{function to compute the loglikelihood: either centered or uncentered}

\item{constraint}{constraint on eta}

\item{thetaInds}{relevant indices}

\item{innerIndices}{internal indices}
}
\value{
List containing a minimum criterion coefficient vector and the criterion for that vector
}
\description{
Takes a list of coefficient values and finds the values which minimize AIC or BIC
}
\examples{
#criterionFit(thetaList,X,z,A,BIC,logLike,constraint,thetaInds,innerIndices)
}
\keyword{AIC,}
\keyword{BIC}

