% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centeredLogLikelihood.R
\name{centeredLogLikelihood}
\alias{centeredLogLikelihood}
\title{Centered model log pseudolikelihood}
\usage{
centeredLogLikelihood(theta, X, z, A, constraint, thetaInds, innerIndices)
}
\arguments{
\item{theta}{a matrix of coefficients with dimension (p+(k-1)*length(A)) by k; frequently A will have length 1}

\item{X}{nxp design matrix}

\item{z}{nxk response matrix}

\item{A}{a list of adjacency matrices}

\item{constraint}{constraint on eta}

\item{thetaInds}{relevant indices}

\item{innerIndices}{internal grid indices}
}
\value{
a log (pseudo-)likelihood
}
\description{
Computes a log pseudolikelihood for the centered model, taking coefficients, a design matrix, a response matrix, and a list of adjacency matrices
}
\examples{
#g=centeredLogLikelihood(theta,X,z,A)
}
\keyword{centered,}
\keyword{gradient}

