% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqp-package.R
\docType{package}
\name{aqp-package}
\alias{aqp-package}
\alias{aqp}
\alias{aqp.env}
\title{Algorithms for Quantitative Pedology}
\description{
The aqp (Algorithms for Quantitative Pedology) package for R was developed
to address some of the difficulties associated with processing soils
information, specifically related to visualization, aggregation, and
classification of soil profile data. This package is based on a mix of S3/S4
functions and classes, and most functions use basic dataframes as input,
where rows represent soil horizons and columns define properties of those
horizons. Common to most functions are the requirements that horizon
boundaries are defined as depth from 0, and that profiles are uniquely
defined by an id column. The aqp package defines an S4 class,
"SoilProfileCollection", for storage of profile-level metadata, as well as
summary, print, and plotting methods that have been customized for common
tasks related to soils data.
}
\details{
Demos: \code{demo(aqp)}

\href{http://ncss-tech.github.io/AQP/}{Project homepage}
}
\seealso{
\verb{depths<-()}, \code{SoilProfileCollection()}, \code{\link{sp1}}, \code{\link{sp2}}, \code{\link{sp3}}, \code{\link{sp4}}, \code{\link{sp5}}, \code{\link{sp6}}
}
\author{
Dylan E. Beaudette \href{mailto:debeaudette@ucdavis.edu}{debeaudette@ucdavis.edu}, Pierre Roudier, Andrew G. Brown
}
\keyword{package}
