% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hzBoundary.R
\name{hzTopographyCodeToLineType}
\alias{hzTopographyCodeToLineType}
\title{Convert Horizon Boundary Topography to Line Type}
\usage{
hzTopographyCodeToLineType(
  x,
  codes = c("S", "W", "I", "B"),
  lty = c(1, 2, 3, 4)
)
}
\arguments{
\item{x}{vector of boundary topography codes to be converted}

\item{codes}{code values, adjust as needed}

\item{lty}{line types}
}
\value{
vector of line types with same length as \code{x}
}
\description{
This function will convert USDA-NCSS horizon boundary topography codes into line types, based on the \href{https://www.nrcs.usda.gov/wps/portal/nrcs/detail/soils/research/guide/?cid=nrcs142p2_054184}{Field Book for Describing and Sampling Soils, version 3.0}.
}
\details{
Visualization of horizon boundary topography can be difficult, line type offers an additional visual cue. See \code{hzTopographyCodeToOffset} for an offset-based approach. Additional examples are available in the \href{https://ncss-tech.github.io/AQP/aqp/hz-boundaries.html}{Visualization of Horizon Boundaries tutorial}.
}
\references{
\href{https://www.nrcs.usda.gov/wps/portal/nrcs/detail/soils/research/guide/?cid=nrcs142p2_054184}{Field Book for Describing and Sampling Soils, version 3.0}
}
\seealso{
\code{\link{plotSPC}, \link{hzTopographyCodeToOffset}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
