\name{get.ml.hz}
\alias{get.ml.hz}
\title{Determine ML Horizon Boundaries}
\description{This function accepts input from \code{slab()} along with a vector of horizon names, and returns a \code{data.frame} of the most likely horizon boundaries.}
\usage{
get.ml.hz(x, o.names)
}
\arguments{
  \item{x}{output from \code{\link{slab}}}
  \item{o.names}{an optional character vector of horizon designations that will be used in the final table}
}

\details{This function expects that \code{x} is a data.frame generated by \code{\link{slab}}. If \code{x} was not generated by \code{slab}, then \code{o.names} is required.}

\value{
A dataframe with the following columns:
	\item{hz}{horizon names}
	\item{top}{top boundary}
	\item{bottom}{bottom boundary}
	\item{confidence}{integrated probability over thickness of each ML horizon, rounded to the nearest integer}
  \item{pseudo.brier}{A "pseudo"" Brier Score for a multi-class prediction, where the most-likely horizon label is treated as the "correct" outcome. Details on the calculation for traditional Brier Scores here: \url{https://en.wikipedia.org/wiki/Brier_score}. Lower values suggest better agreement between ML horizon label and class-wise probabilities.}
  \item{mean.H}{mean Shannon entropy (bits), derived from probabilities within each most-likely horizon. Larger values suggest more confusion within each ML.}
	}

\author{D.E. Beaudette}

\seealso{\code{\link{slab}}}
\examples{
data(sp1)
depths(sp1) <- id ~ top + bottom

# normalize horizon names: result is a factor
sp1$name <- generalize.hz(sp1$name, 
  new=c('O','A','B','C'), 
  pat=c('O', '^A','^B','C'))

# compute slice-wise probability so that it sums to contributing fraction, from 0-150
a <- slab(sp1, fm= ~ name, cpm=1, slab.structure=0:150)

# generate table of ML horizonation
get.ml.hz(a)
}

\keyword{manip}
