% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-input.R
\name{set_input_export}
\alias{set_input_export}
\title{Retrieve chart's base64 dataURI.}
\usage{
set_input_export(ax, inputId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{ax}{An \code{apexcharts} \code{htmlwidget} object.}

\item{inputId}{The id that will be used server-side for retrieving data.}

\item{session}{The Shiny session.}
}
\value{
An \code{apexcharts} \code{htmlwidget} object.
}
\description{
Retrieve chart's base64 dataURI.
}
\examples{
library(shiny)
library(apexcharter)

ui <- fluidPage(
  fluidRow(
    column(
      width = 8, offset = 2,
      tags$h2("Export PNG"),
      actionButton("redraw", "Redraw chart"),
      apexchartOutput("chart"),
      verbatimTextOutput("result"),
      uiOutput(outputId = "image")
    )
  )
)

server <- function(input, output, session) {
  
  output$chart <- renderApexchart({
    input$redraw
    apexchart() \%>\%
      ax_chart(type = "bar") \%>\%
      ax_series(
        list(
          name = "Example",
          data = sample(1:100, 5)
        )
      ) \%>\%
      ax_xaxis(
        categories = LETTERS[1:5]
      ) \%>\% 
      set_input_export("export")
  })
  
  output$result <- renderPrint({
    input$export
  })

  output$image <- renderUI({
    tags$img(src = input$export)
  })
  
}

if (interactive())
  shinyApp(ui, server)

}
