% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{add_point}
\alias{add_point}
\title{Add an annotation point}
\usage{
add_point(
  ax,
  x,
  y,
  size = 5,
  color = "#000",
  fill = "#FFF",
  width = 2,
  shape = "circle",
  radius = 2,
  label = NULL,
  ...
)
}
\arguments{
\item{ax}{An \code{apexcharts} \code{htmlwidget} object.}

\item{x}{Coordinate(s) on the x-axis.}

\item{y}{Coordinate(s) on the y-axis.}

\item{size}{Size of the marker.}

\item{color}{Stroke Color of the marker point.}

\item{fill}{Fill Color of the marker point.}

\item{width}{Stroke Size of the marker point.}

\item{shape}{Shape of the marker: \code{"circle"} or \code{"square"}.}

\item{radius}{Radius of the marker (applies to square shape).}

\item{label}{Add a label to the shade, use a \code{character}
or see \code{\link{label}} for more controls.}

\item{...}{Additional arguments, see
\url{https://apexcharts.com/docs/options/annotations/} for possible options.}
}
\value{
An \code{apexcharts} \code{htmlwidget} object.
}
\description{
Add an annotation point
}
\examples{

library(apexcharter)

# On scatter chart
apex(
  data = iris,
  aes(Sepal.Length, Sepal.Width),
  "scatter"
) \%>\% 
  add_point(
    x = mean(iris$Sepal.Length),
    y = mean(iris$Sepal.Width)
  )

# Some options
apex(
  data = iris,
  aes(Sepal.Length, Sepal.Width),
  "scatter"
) \%>\% 
  add_point(
    x = mean(iris$Sepal.Length),
    y = mean(iris$Sepal.Width), 
    fill = "firebrick",
    color = "firebrick",
    size = 8,
    label = label(text = "Mean", offsetY = 0)
  )


# Several points
clusters <- kmeans(iris[, 1:2], 3)
apex(
  data = iris,
  aes(Sepal.Length, Sepal.Width),
  "scatter"
) \%>\% 
  add_point(
    x = clusters$centers[, 1],
    y = clusters$centers[, 2]
  )











}
