% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/apaTables.R
\docType{package}
\name{apaTables}
\alias{apaTables}
\alias{apaTables-package}
\title{Create American Psychological Association (APA) Style Tables}
\description{
A common task faced by researchers is the creation of APA style (i.e., \emph{American Psychological Association} style) tables from statistical output. In R a large number of function calls are often needed to obtain all of the desired information for a single APA style table. As well, the process of manually creating APA style tables in a word processor is prone to transcription errors. This package creates Word files (.doc files) containing APA style tables for several types of analyses. Using this package minimizes transcription errors and reduces the number commands needed by the user. Examples are provided in this documentation and at \url{http://www.StatsCanBeFun.com}. Currently, the following tables can be created:
\itemize{
  \item Correlation tables - Correlation tables (with confidence intervals and descriptive statistics) are created from data frames using \code{\link{apa.cor.table}}
  \item Single "block" regression tables - Single "block" regression tables are created from a regression object using \code{\link{apa.reg.table}}
  \item Multiple "block" regression tables - Multiple "block" regression tables are created from regression objects using \code{\link{apa.reg.table}}
  \item ANOVA cell tables - ANOVA mean/standard deviation tables for 1- and 2-way designs are created from data frames using \code{\link{apa.1way.table}} and \code{\link{apa.2way.table}}
  \item Standardized mean difference (i.e., \emph{d}-value) tables (with confidence intervals and descriptive statistics) illustrating all possible paired comparisons using a single independent variable are created from data frames using \code{\link{apa.d.table}}
 }
\tabular{ll}{
Package: \tab apaTables\cr
Type: \tab Package\cr
Version: \tab 1.0.4\cr
Date: \tab 2015-011-20\cr
License: \tab Unlimited\cr
}
}
\author{
\tabular{ll}{
Author: \tab David J. Stanley \email{dstanley@uoguelph.ca}\cr
Maintainer: \tab David J. Stanley \email{dstanley@uoguelph.ca}
}
}

