% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_analysis.R
\name{violin_compare}
\alias{violin_compare}
\title{Compares summary statistics from two datasets as side-by-side violin plots}
\usage{
violin_compare(df_summary, by, col_name, export = FALSE, out = NULL)
}
\arguments{
\item{df_summary}{data frame of summary statistics from both datasets to be compared}

\item{by}{GPS or Date}

\item{col_name}{variable in df_summary to be used for the y-axis, as a string}

\item{export}{logical, whether to export plot, defaults to False}

\item{out}{.png file name to save plot when export is True}
}
\value{
side-by-side violin plots
}
\description{
Compares summary statistics from two datasets as side-by-side violin plots
}
\examples{
# Violin plot comparing unfiltered and filtered demo data summaries by date for a single variable
## Summarise unfiltered demo
unfiltered_summary <- summarise_anidf(demo_unfiltered_elev, Date, Latitude, Longitude, 
Distance, Course, Rate, Elevation, daily=FALSE)

## Summarise filtered demo
filtered_summary <- summarise_anidf(demo_filtered_elev, Date, Latitude, Longitude, 
Distance, Course, Rate, Elevation, daily=FALSE)

## Join
summary <- join_summaries(unfiltered_summary, filtered_summary, "Date", daily=FALSE)

## Violin plot

violin_compare(summary, Date, "meanElev")

}
