% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbundle-set.R, R/rintersect.R, R/rsetdiff.R,
%   R/runion.R
\name{rbundle-set}
\alias{rbundle-set}
\alias{rintersect}
\alias{rsetdiff}
\alias{runion}
\title{Create a new set-based recurrence bundle}
\usage{
rintersect()

rsetdiff()

runion()
}
\value{
An empty rbundle.
}
\description{
Often, a single rrule will be sufficient. However, more complex
recurrence objects can be constructed by combining multiple rschedules into
a \emph{recurrence bundle}.

There are three types of recurrence bundles provided in almanac, each of
which construct their event sets by performing a set operation on the
underlying event sets of the rschedules in the bundle.
\itemize{
\item \code{runion()} takes the union.
\item \code{rintersect()} takes the intersection.
\item \code{rsetdiff()} takes the set difference.
}

Once you have created a recurrence bundle, you can:
\itemize{
\item Add recurrence rules or other recurrence bundles with \code{\link[=add_rschedule]{add_rschedule()}}.
\item Forcibly include dates in its event set with \code{\link[=add_rdates]{add_rdates()}}.
\item Forcibly exclude dates from its event set with \code{\link[=add_exdates]{add_exdates()}}.
}
}
\details{
For \code{rsetdiff()}, the event set is created "from left to right" and depends
on the order that the rschedules were added to the bundle.
}
\examples{
since <- "2019-04-01"
until <- "2019-05-31"

on_weekends <- weekly(since = since, until = until) \%>\%
  recur_on_weekends()

on_25th <- monthly(since = since, until = until) \%>\%
  recur_on_mday(25)

# On weekends OR the 25th of the month
ru <- runion() \%>\%
  add_rschedule(on_weekends) \%>\%
  add_rschedule(on_25th)

alma_events(ru)

# On weekends AND the 25th of the month
ri <- rintersect() \%>\%
  add_rschedule(on_weekends) \%>\%
  add_rschedule(on_25th)

alma_events(ri)

# On weekends AND NOT the 25th of the month
rsd1 <- rsetdiff() \%>\%
  add_rschedule(on_weekends) \%>\%
  add_rschedule(on_25th)

alma_events(rsd1)

# On the 25th of the month AND NOT the weekend
rsd2 <- rsetdiff() \%>\%
  add_rschedule(on_25th) \%>\%
  add_rschedule(on_weekends)

alma_events(rsd2)
}
\seealso{
\code{\link[=add_rschedule]{add_rschedule()}}
}
