% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affineGrob.r
\name{affineGrob}
\alias{affineGrob}
\alias{grid.affine}
\title{Affine transformation grob}
\usage{
affineGrob(
  grob,
  vp_define = NULL,
  transform = NULL,
  vp_use = NULL,
  name = NULL,
  gp = grid::gpar(),
  vp = NULL
)

grid.affine(...)
}
\arguments{
\item{grob}{A grid grob to perform affine transformations on.  Passed to \code{\link[grid:grid.group]{grid::defineGrob()}} as its \code{src} argument.}

\item{vp_define}{\code{\link[grid:viewport]{grid::viewport()}} to define grid group in.  Passed to \code{\link[grid:grid.group]{grid::defineGrob()}} as its \code{vp} argument.
This will cumulative with the current viewport and the \code{vp} argument (if any),
if this cumulative viewport falls outside the graphics device drawing area this
grob may be clipped on certain graphics devices.}

\item{transform}{An affine transformation function.
If \code{NULL} default to \code{\link[grid:viewportTransform]{grid::viewportTransform()}}.
Passed to \code{\link[grid:grid.group]{grid::useGrob()}} as its \code{transform} argument.}

\item{vp_use}{\code{\link[grid:viewport]{grid::viewport()}} passed to \code{\link[grid:grid.group]{grid::useGrob()}} as its \code{vp} argument.}

\item{name}{A character identifier (for grid).}

\item{gp}{A \code{\link[grid:gpar]{grid::gpar()}} object.}

\item{vp}{A \code{\link[grid:viewport]{grid::viewport()}} object (or \code{NULL}).}

\item{...}{Passed to \code{affineGrob()}}
}
\value{
A \code{\link[grid:grid.grob]{grid::gTree()}} (grob) object of class "affine".
As a side effect \code{grid.affine()} draws to the active graphics device.
}
\description{
\code{affineGrob()} is a grid grob function to facilitate
using the group affine transformation features introduced in R 4.2.
}
\details{
Not all graphics devices provided by \code{grDevices} or other R packages support the \href{https://www.stat.auckland.ac.nz/~paul/Reports/GraphicsEngine/groups/groups.html}{affine transformation feature introduced in R 4.2}.
If \code{isTRUE(getRversion() >= '4.2.0')} then the active graphics device should support this feature if \code{isTRUE(grDevices::dev.capabilities()$transformations)}.
In particular the following graphics devices should support the affine transformation feature:
\itemize{
\item R's \code{\link[grDevices:pdf]{grDevices::pdf()}} device
\item R's 'cairo' devices e.g. \code{\link[grDevices:cairo]{grDevices::cairo_pdf()}}, \code{grDevices::png(type = 'cairo')}, \code{\link[grDevices:cairo]{grDevices::svg()}}, \code{grDevices::x11(type = 'cairo')}, etc. If \code{isTRUE(capabilities('cairo'))} then R was compiled with support for the 'cairo' devices .
\item R's 'quartz' devices (since R 4.3.0) e.g. \code{\link[grDevices:quartz]{grDevices::quartz()}}, \code{grDevices::png(type = 'quartz')}, etc. If \code{isTRUE(capabilities('aqua'))} then R was compiled with support for the 'quartz' devices (generally only \code{TRUE} on macOS systems).
\item \code{ragg}'s devices (since v1.3.0) e.g. \code{\link[ragg:agg_png]{ragg::agg_png()}}, \code{\link[ragg:agg_capture]{ragg::agg_capture()}}, etc.
}
}
\examples{
if (require("grid")) {
  grob <- grobTree(rectGrob(gp = gpar(fill = "blue", col = NA)),
                   circleGrob(gp=gpar(fill="yellow", col = NA)),
                   textGrob("RSTATS", gp=gpar(fontsize=32)))
  grid.newpage()
  pushViewport(viewport(width=unit(4, "in"), height=unit(2, "in")))
  grid.draw(grob)
  popViewport()
}

if (require("grid") &&
    getRversion() >= "4.2.0" &&
    isTRUE(dev.capabilities()$transformations)) {
  # Only works if active graphics device supports affine transformations
  # such as `png(type="cairo")` on R 4.2+
  vp_define <- viewport(width=unit(2, "in"), height=unit(2, "in"))
  affine <- affineGrob(grob, vp_define=vp_define)
  grid.newpage()
  pushViewport(viewport(width=unit(4, "in"), height=unit(2, "in")))
  grid.draw(affine)
  popViewport()
}
if (require("grid") &&
    getRversion() >= "4.2.0" &&
    isTRUE(dev.capabilities()$transformations)) {
  # Only works if active graphics device supports affine transformations
  # such as `png(type="cairo")` on R 4.2+
  settings <- affine_settings(xy = list(x = c(3/3, 2/3, 0/3, 1/3),
                                        y = c(2/3, 1/3, 1/3, 2/3)),
                              unit = "snpc")
  affine <- affineGrob(grob,
                       vp_define = vp_define,
                       transform = settings$transform,
                       vp_use = settings$vp)
  grid.newpage()
  grid.draw(affine)
}
}
\seealso{
See \code{\link[=affine_settings]{affine_settings()}} for computing good \code{transform} and \code{vp_use} settings.
See \url{https://www.stat.auckland.ac.nz/~paul/Reports/GraphicsEngine/groups/groups.html}
for more information about the group affine transformation feature.
See \code{\link[=isocubeGrob]{isocubeGrob()}} which wraps this function to render isometric cubes.
}
