% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_box}
\alias{plot_box}
\title{plot_box}
\usage{
plot_box(
  df,
  x,
  y,
  z = NULL,
  base_size = 25,
  line_width = 0.5,
  outlier_size = 1.5,
  text_color = "black",
  facet = FALSE,
  facet_x = NULL,
  facet_y = NULL,
  style = "bw"
)
}
\arguments{
\item{df}{A data frame.}

\item{x}{<[`data-masking`][ggplot2::aes]> Column mapped to the x-axis.}

\item{y}{<[`data-masking`][ggplot2::aes]> Column mapped to the y-axis.}

\item{z}{<[`data-masking`][ggplot2::aes]> Optional column mapped to fill colour.}

\item{base_size}{Base font size. Default 25.}

\item{line_width}{Box outline width. Default 0.5.}

\item{outlier_size}{Outlier point size. Default 1.5.}

\item{text_color}{Text colour. Default \code{"black"}.}

\item{facet}{Logical; add facet grid? Default \code{FALSE}.}

\item{facet_x}{Column name (string) for the horizontal facet dimension.}

\item{facet_y}{Column name (string) for the vertical facet dimension.}

\item{style}{Theme style. Default \code{"bw"}.}
}
\value{
A \code{ggplot} object.
}
\description{
Create a box plot with mean overlay using the aelab theme.
}
\examples{
\dontrun{
df <- data.frame(x = rep(c("A","B"), each = 5), y = c(1:5, 3:7))
plot_box(df, x, y)
}
}
