% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warnings.R
\name{warn_if_vars_exist}
\alias{warn_if_vars_exist}
\title{Warn If a Variable Already Exists}
\usage{
warn_if_vars_exist(dataset, vars)
}
\arguments{
\item{dataset}{A \code{data.frame}}

\item{vars}{\code{character} vector of columns to check for in \code{dataset}}
}
\value{
No return value, called for side effects
}
\description{
Warn if a variable already exists inside a dataset
}
\examples{
library(admiral.test)
data(admiral_dm)

## No warning as `AAGE` doesn't exist in `dm`
warn_if_vars_exist(admiral_dm, "AAGE")

## Issues a warning
warn_if_vars_exist(admiral_dm, "ARM")
}
\author{
Thomas Neitmann
}
\keyword{warning}
