% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{Bootstrap}
\alias{Bootstrap}
\title{Bootstrap}
\usage{
Bootstrap(x, Stat, n = 500, Conf = 0.95, ReturnSD = FALSE, ...)
}
\arguments{
\item{x}{a numeric vector. The sample of interest}

\item{Stat}{the function (to calculate the statistic) to be applied to the bootstrapped samples. For example mean, max, or median.}

\item{n}{the number of bootstrapped samples (default 500). i.e. the size of the derived sampling distribution.}

\item{Conf}{the confidence level of the intervals (default 0.95). Must be between 0 and 1.}

\item{ReturnSD}{Logical argument with a default of FALSE. If true the bootstrapped sampling distribution is returned.}

\item{...}{further arguments for the Stat function. For example if you use the GEVAM function you might want to add RP = 50 to derive a sampling distribution for the 50-year quantile.}
}
\value{
If ReturnSD is FALSE a data.frame is returned with one row and three columns; central, lower, and upper. If ReturnSD is TRUE, the sampling distribution is returned.
}
\description{
Resampling with replacement to approximate the sampling distribution of a statistic and quantify uncertainty.
}
\details{
The bootstrapping procedure resamples from a sample length(x) * n times with replacement. After splitting into n samples of size length(x), the statistic of interest is calculated on each.
}
\examples{
# Extract an AMAX sample and quantify uncertainty for the Gumbel estimated 50-year flow
am_203018 <- GetAM(203018)
Bootstrap(am_203018$Flow, Stat = GumbelAM, RP = 50)

# Quantify uncertainty for the sample standard deviation at the 90\% confidence level
Bootstrap(am_203018$Flow, Stat = sd, Conf = 0.90)

# Return the sampling distribution of the mean and plot an associated histogram
samp_dist <- Bootstrap(am_203018$Flow, Stat = mean, ReturnSD = TRUE)
hist(samp_dist)

}
\author{
Anthony Hammond
}
