% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_pancan_value.R
\name{vis_gene_msi_cor}
\alias{vis_gene_msi_cor}
\title{Visualize Correlation between Gene and MSI (Microsatellite instability)}
\usage{
vis_gene_msi_cor(Gene = "TP53", cor_method = "spearman", data_type = "mRNA")
}
\arguments{
\item{Gene}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{cor_method}{correlation method}

\item{data_type}{choose gene profile type,
including "mRNA", "transcript", "protein", "mutation", "cnv" (-2, -1, 0, 1, 2),
"cnv_gistic2", "methylation", "miRNA".}
}
\description{
Visualize Correlation between Gene and MSI (Microsatellite instability)
}
\examples{
\dontrun{
p <- vis_gene_msi_cor(Gene = "TP53")
}
}
