% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.r
\name{corTest}
\alias{corTest}
\title{Test for Correlation}
\usage{
corTest(x, y, method = "both", adj_method = "BH", rm0 = TRUE)
}
\arguments{
\item{x}{data.frame.}

\item{y}{data.frame.}

\item{method}{character. 'pearson', 'spearman' or 'both'. Default 'both'}

\item{adj_method}{character. choose one method in \code{p.adjust.methods}. Default 'BH'}

\item{rm0}{logical. whether remove 0 in each analyse. Default TRUE.}
}
\value{
a correlation results data.frame
}
\description{
Correlation analysis for each row (each to each) between two data-frames.
}
\examples{
treatment = data.frame(S1 = sample(10, 5), S2 = sample(10, 5), S3 = sample(10, 5))
control   = data.frame(S4 = sample(20, 5), S5 = sample(20, 5), S6 = sample(10, 5))
result    = corTest(treatment, control, method = 'pearson')
head(result)

}
