% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{SplitsInBinaryTree}
\alias{SplitsInBinaryTree}
\alias{SplitsInBinaryTree.phylo}
\alias{SplitsInBinaryTree.Splits}
\alias{SplitsInBinaryTree.list}
\alias{SplitsInBinaryTree.multiPhylo}
\alias{SplitsInBinaryTree.numeric}
\title{Maximum splits in an \emph{n}-leaf tree}
\usage{
SplitsInBinaryTree(tree)

\method{SplitsInBinaryTree}{phylo}(tree)

\method{SplitsInBinaryTree}{Splits}(tree)

\method{SplitsInBinaryTree}{list}(tree)

\method{SplitsInBinaryTree}{multiPhylo}(tree)

\method{SplitsInBinaryTree}{numeric}(tree)
}
\arguments{
\item{tree}{An object of a supported format that represents a tree or
set of trees, from which the number of leaves will be calculated.}
}
\value{
\code{SplitsInBinaryTree()} returns an integer vector detailing the number of
unique non-trivial splits in a binary tree with \emph{n} leaves.
}
\description{
\code{SplitsInBinaryTree()} is a convenience function to calculate the number of splits
in a fully-resolved (binary) tree with \emph{n} leaves.
}
\details{
This function will soon be removed from 'TreeDist' and included instead
in 'TreeTools' v1.0.1.
}
\examples{
tree <- TreeTools::BalancedTree(8)
SplitsInBinaryTree(tree)
SplitsInBinaryTree(TreeTools::as.Splits(tree))
SplitsInBinaryTree(8)
SplitsInBinaryTree(list(tree, tree))
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\keyword{internal}
